using System;
using System.Diagnostics.CodeAnalysis;

namespace DrugiKrug2020Frilenseri
{
    class Program
    {
        static int podela(Frilenser[] a, int l, int d)
        {
            Frilenser p;
            double pivot = a[l].p;
            int k = l + 1;
            for (int i = l + 1; i <= d; i++)
            {
                if (a[i].p < pivot)
                {
                    p = a[i]; a[i] = a[k]; a[k] = p; k++;
                }
            }// k se nalazi na prvom koji nije <= od pivota
            k--;
            p = a[k]; a[k] = a[l]; a[l] = p;
            return k;
        }

        static void qsort(Frilenser[] a, int l, int d)
        {
            if (l <= d)
            {
                int k = podela(a, l, d);
                qsort(a, l, k - 1);
                qsort(a, k + 1, d);
            }
        }
        struct Frilenser
        {
            public int a;
            public double p;
        }
        static bool SviJednaki(Frilenser[] niz, int n)
        {
            for(int i = 0; i < n - 1; i++)
            {
                if (niz[i].a != niz[i + 1].a) return false;
            }
            return true;
        }
        static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            Frilenser[] niz = new Frilenser[n];
            for(int i = 0; i < n; i++)
            {
                string[] s = Console.ReadLine().Split();
                niz[i].a = int.Parse(s[0]);
                niz[i].p = double.Parse(s[1]);
            }

            if ( SviJednaki(niz, n))
            {
                double suma = 0; double prosek;
                for(int i = 0; i < n; i++)
                {
                    suma += niz[i].p;
                }
                prosek = suma / n;
                qsort(niz, 0, n - 1);
                for (int i=0; i<n-1; i++)
                {
                    if (niz[i].p <= prosek && niz[i + 1].p >= prosek)
                    {
                        double s1 = 0; double s2 = 0;
                        for (int j = 0; j < n; j++)
                        {
                            if (niz[i].p <= niz[j].p)
                            {
                                s1 += (niz[i].p / 100) * niz[j].a;
                            }
                        }
                        for (int j = 0; j < n; j++)
                        {
                            if (niz[i + 1].p <= niz[j].p)
                            {
                                s2 += (niz[i + 1].p / 100) * niz[j].a;
                            }
                        }
                        if (s1 > s2) Console.WriteLine(s1);
                        else Console.WriteLine(s2);
                        break;
                    }
                }
            }
            else
            {
                double max = 0;
                double porez_kraj = 0;
                bool svi_jednaki = true;
                for (int i = 0; i < n; i++)
                {
                    double porez = niz[i].p;
                    double suma = 0;


                    for (int j = 0; j < n; j++)
                    {
                        if (porez <= niz[j].p)
                        {
                            suma += (porez / 100) * niz[j].a;
                        }
                    }
                    if (suma > max) { max = suma; porez_kraj = porez; }
                }


                Console.WriteLine(max + " " + porez_kraj);
            }
        }
    }
}